<?php
/*
Plugin Name: isEngine Attachment Enhancements
Plugin URI: http://houseoflaudanum.com/wordpress/
Description: Attachment ordering, thumbnail cropping, parent post alteration
Version: 0.60
Author: Wintermoss Snow
Author URI: http://houseoflaudanum.com/wordpress/
*/

//	no longer required ( as of wp2.5 )
//	fixed . must patch wp-includes/post.php
//	at the moment, if we give the post an order ( at least from browse all ) 
//	it resets its post parent, and from then on we can't change anything .

/*
//	must patch wp-includes/post.php ** not required any more ( as of 2.5 **
//	added mr.snow 12/8/2007
	if ( isset ($object['post_parent'] ) ) {
		$post_parent = $object['post_parent'];
	}
*/


/*
	change log
	
	v0.34	support for flv's
	v0.35	fixes for the video functions
	v0.36	includes first-video convenience object
	v0.37	fixed first-video thumbnail bug
	v0.38	allow resize of editor windows
	v0.39	do not return results for protected posts
	v0.40	support for wordpress v2.5 media gallery
	v0.41	compensate for wordpress in a subdir
	v0.42	now supports is_getAttachmentsByName('string')
	v0.43	support for mp3 and wav, includes first-audio convenience object
	v0.44	now supports is_getAttachmentsByDescription('string') and returns details for post_parent
	v0.45	no longer returns medium if no medium file exists
	v0.46	fixed problems with the video thumbnails, added mov and mpg types
	v0.47	fixed cropping in firefox
	v0.48	object includes `caption' (post_excerpt)
	v0.49	sorts attachments from a directory alphabetically 
	v0.50	handles missing thumbnails (all tests) by sending the attachment guid
	v0.51	save post_parent field
	v0.52	fixed wp in a subdir, parent select width
	v0.53	all attachments can have post parent changes
	v0.54	crop sizes can have separate preferences
	v0.55	minor error checking
	v0.56	various fixes
	v0.57	hide revisions in post parent selection
	v0.58	fix thumbnail creation from directories
	v0.59	fix attachment unparenting bug and rework video thumbnailing
	v0.60	add is_getFirstImage
	
	TO DO
	-	integrate isengine options with wordpress ones in 2.5 ( image sizes )
	-	width was turning up blank as $a->$medium->$width wasn't working
	-	separate thumbs and medium size preferences
	-	show crop / parent in initial add dialog
	-	respect option check boxes or remove them .
	-	js auto resize doesn't do a good job when originals are vertical
	v	if you use save all changes on the first upload page, the new attachment is unparented
	-	also perhaps other attachments are unparented .
	=	added but untested. allow video poster frames to be selected by inserting the guid into the caption field or via a drop down selector
	
*/

global $is_config, $columns;
$columns = "post_title, post_content, post_excerpt, post_mime_type, guid, ID";

if ( !is_admin() ) {
    return;
}

//	this will generate defaults if there are none.
is_check_config();

//	get the settings
$is_config = get_option('is_config');


function is_Attachments() {
	add_options_page('Attachments', 'Attachments', 10, __FILE__, 'is_Options');
}


function is_Options(){

	
//	this will generate defaults if there are none.
	is_check_config();
	
	$is_config = get_option('is_config');
	global $wpdb, $table_prefix;
	

// Default options configuration page
	if ( !isset($_GET['error']) && current_user_can('level_10') ) {
		?>
		<style type='text/css'>
			input[type='text'] {
				width : 30px;
			}
		</style>
		
		<div class="wrap">
		  	<h2><?php _e('isEngine Attachment Options', 'is');?></h2>
		  	<form method="post" action="<?php echo $_SERVER['REQUEST_URI']?>&amp;updated=true">
		    	<input type="hidden" name="is_submit_options" value="true" />

				<h3>General attachment options</h3>
				
<table class="form-table">
<tr><td>
				<input type='checkbox' name='parent' value='true' <?php if ( $is_config['parent'] ) echo 'checked'; ?> />
				Display attachment parent select menu.
</td></tr>
<tr><td>
				<input type='checkbox' name='menu_order' value='true' <?php if ( $is_config['menu_order'] ) echo 'checked'; ?> />
				Display attachment order.
</td></tr>
<tr><td>
				<input type='text' name='auto_directory' style='width : 200px;' value='<?php echo $is_config['auto_directory']; ?>' />
				Parent directory for auto indexing images.
</td></tr>
</table>



<?php
	if ( get_bloginfo('version') < 2.5 ) { 
?>
				<h3>Attachment thumbnails options</h3>
					<div style='float : left;'>
							<p>
							<label for="thumbnail_w"><?php _e('Width','is');?>:</label>
							<input type="text" id="thumbnail_w" name="thumbnail_w" value="<?php echo $is_config['thumbnail_w']; ?>" onchange="updatePreview(this)" />px
							</p> 

							<p>
							<label for="thumbnail_h"><?php _e('Height','is');?>:</label>
							<input type="text" id="thumbnail_h" name="thumbnail_h" value="<?php echo $is_config['thumbnail_h']; ?>" onchange="updatePreview(this)" />px
							</p>
							<hr />
<?php
	} else {		
?>
				<h3>Attachment size options</h3>
				<table class="form-table" border=0>
					<tr>
						<th width='100'>
							Type
						</th>
						<th width='100'>
							Width
						</th>
						<th width='100'>
							Height
						</th>
						<th width='100'>
							Scale/Resize
						</th>
					</tr>

					<tr>
						<td width=100>
							<span style='width : 80px; display : inline-block;'>
								Thumbnail
							</span>
						</td><td width=100>
							<input type="text" id="thumbnail_w" name="thumbnail_w" value="<?php echo $is_config['sizes']['thumbnail']['width']; ?>" onchange="updatePreview(this)" />px
						</td><td width=100>
							<input type="text" id="thumbnail_h" name="thumbnail_h" value="<?php echo $is_config['sizes']['thumbnail']['height']; ?>" onchange="updatePreview(this)" />px
						</td><td>
							
								<input type="radio" id="" name="th_type" value="" <?php if ( $is_config['th_type'] == '' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_fill"><?php _e('Fit','is');?></label> 

								<input type="radio" id="th_fill" name="th_type" value="fill" <?php if ( $is_config['th_type'] == 'fill' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_fill"><?php _e('Fill','is');?></label> 

								<input type="radio" id="th_crop" name="th_type" value="crop" <?php if ( $is_config['th_type'] == 'crop' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_crop"><?php _e('Crop.','is');?></label> 
							
						</td>
					</tr>
					<tr>
						<td>
							<span style='width : 80px; display : inline-block;'>
								Medium
							</span>
						</td><td>
							<input type="text" id="medium_w" name="medium_w" value="<?php echo $is_config['sizes']['medium']['width']; ?>" onchange="updatePreview(this)" />px
						</td><td>
							<input type="text" id="medium_h" name="medium_h" value="<?php echo $is_config['sizes']['medium']['height']; ?>" onchange="updatePreview(this)" />px
						</td><td>
							
								<input type="radio" id="" name="medium_type" value="" <?php if ( $is_config['medium_type'] == '' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_fit"><?php _e('Fit','is');?></label> 

								<input type="radio" id="med_fill" name="medium_type" value="fill" <?php if ( $is_config['medium_type'] == 'fill' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_fill"><?php _e('Fill','is');?></label> 

								<input type="radio" id="med_crop" name="medium_type" value="crop" <?php if ( $is_config['medium_type'] == 'crop' ) echo checked; ?> onclick="updatePreview(this)" />
								<label for="th_crop"><?php _e('Crop.','is');?></label> 
							
						</td>
					</tr>
				</table>

<?php
	} 
?>


					<h3>Resizing Preview</h3>
<table class="form-table">
<td rowspan='5'>
							<div class='box' id='box' style='width : 40px; height : 40px; float : left'>
								<div class='fill' id='fill' style='width : 40px; height : 20px; left : 0px; top : 9px;'>
									&nbsp;
								</div>
							</div>
</td></tr>
</table>

<!--
					<div style='float : left;'>
							
							<div class='box' style='width : 40px; height : 40px;'>
								<div class='fill' style='width : 40px; height : 20px; left : 0px; top : 9px;'>
									&nbsp;
								</div>
							</div>
							
							<div class='box' style='width : 40px; height : 40px;'>
								<div class='fill' style='width : 80px; height : 40px; left : -20px; top : 0px;'>
									&nbsp;
								</div>
							</div>

							<div class='box' style='width : 40px; height : 40px;'>
								<div class='fill' style='width : 40px; height : 40px; left : 0px; top : 0px;'>
									&nbsp;
								</div>
							</div>

					</div>
-->

							<style type='text/css'>
								.box {
									border : 1px solid gray;
									margin-left : 80px; 
								}
								
								.fill {
									margin : -1px;
									border : 1px solid blue;
									background-color : cyan;
									opacity : 0.3;
									position : relative;
								}
							</style>
							
							
							<script type='text/javascript'>
								function updatePreview(obj) {

									if ( obj.name.indexOf('th') == 0 ) {
										w = document.getElementById('thumbnail_w').value;
										h = document.getElementById('thumbnail_h').value;
									} else {
										w = document.getElementById('medium_w').value;
										h = document.getElementById('medium_h').value;
									}
									
									if ( w > h * 1.5 )
										r = 1.5;
									else
										r = .75;
									
									box = document.getElementById('box');
									fill = document.getElementById('fill');

									box.style.width = w + 'px';
									box.style.height = h + 'px';
									
									if ( w < h * 1.5 ) {
										fill.style.width = w + 'px';
										fill.style.height = parseInt(w * r ) + 'px';
									} else {
										fill.style.height = h + 'px';
										fill.style.width = parseInt(h * r ) + 'px';
									}
									
									if ( obj.value == 'fill' ) {
									//	alert('fill')
										if ( w > h * 1.5 ) {
											fill.style.width = w + 'px';
											fill.style.height = parseInt(w * 1/r ) + 'px';
										} else {
											fill.style.width = parseInt(h * 1/r ) + 'px';
											fill.style.height = h + 'px';										
										}
									}
									
									if ( obj.value == 'crop' ) {
									//	alert('crop')
										fill.style.width = w + 'px';
										fill.style.height = h + 'px';
									}
									
									fill.style.top = parseInt(h - parseInt(fill.style.height)) / 2 + 'px';
									fill.style.left = parseInt(w - parseInt(fill.style.width)) / 2 + 'px';
									
								}
								
								updatePreview(this);
							</script>
							


                    <!--    <tr valign="top"> 
							<th scope="row"><label for="height"><?php _e('Full Size Maximum Height','is');?>:</label></th> 
							<td><input type="text" name="height" value="<?php echo $is_config['height']; ?>" /></td> 
						</tr>
                        <tr valign="top"> 
							<th scope="row"><label for="width"><?php _e('Full Size Maximum Width','is');?>:</label></th> 
							<td><input type="text" name="width" value="<?php echo $is_config['width']; ?>" /></td> 
						</tr>-->
				
			<div style='clear:both'>
				<hr />				
				    <p class="submit">
				      	<input type="submit" name="is_submit_options" value="<?php _e('Update Options')?> &raquo;" />
				    </p>
				</form>
			</div>
		</div>
		<?

	} // End If

}


function is_getRelatedAttachments() {
//	global $post_id;
	$the_ID = get_the_ID();
	if ( ! isset($the_ID) ) {
		return null;
	} else {
		return is_getAttachments($the_ID);
	}
}


function is_getAttachments($the_ID=null) {
	global $wpdb,$wp_query,$max_width, $columns;
		
	if ( ! is_checkPermission() ) {
		return array();
	}

	if ( ! isset($the_ID) ) {
		$post_obj = $wp_query->get_queried_object();
		$the_ID = $post_obj->ID;
	}
	
	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	
	$query = "SELECT $columns FROM $wpdb->posts WHERE post_type = 'attachment' AND post_parent = $the_ID ORDER BY menu_order";

	$attach = $wpdb->get_results($query);
//	print "about to build ";
//	print count($attach);
	$arr = _buildArray($attach);
	if ( $_REQUEST['debug'] ) {
		print "\n<!--\n";
		print_r($query);
		print_r($attach);
		print "\n-->\n";
	}
	return $arr;
}


function is_getFirstImage($the_ID=null) {
	global $wpdb,$wp_query,$max_width, $columns;
		
	if ( ! is_checkPermission() ) {
		return array();
	}

	if ( ! isset($the_ID) ) {
		$post_obj = $wp_query->get_queried_object();
		$the_ID = $post_obj->ID;
	}
	
	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	
	$query = "SELECT $columns FROM $wpdb->posts WHERE post_type = 'attachment' AND post_parent = $the_ID AND post_mime_type LIKE 'image/%' ORDER BY menu_order LIMIT 1";

	$attach = $wpdb->get_results($query);
//	print "about to build ";
//	print count($attach);
	$arr = _buildArray($attach);
	if ( $_REQUEST['debug'] ) {
		print "\n<!--\n";
		print_r($arr);
		print "\n-->\n";
	}
	
	if ( is_array($arr['images']) )
		$arr = $arr['images'][0];
	return $arr;
}


function is_getAttachmentsByDescription($the_content) {
	return is_getAttachmentsByContent($the_content);
}


function is_getAttachmentsByCaption($the_content) {
	return is_getAttachmentsByExcerpt($the_content);
}


function is_getAttachmentsByName($the_name) {
	global $wpdb,$wp_query,$max_width;
	
	if ( ! is_checkPermission() ) {
		return array();
	}
	
	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	
	$query = "SELECT post_title, post_parent, post_content, post_excerpt, post_mime_type, guid, ID FROM $wpdb->posts WHERE post_type = 'attachment' AND post_title = '$the_name' ORDER BY menu_order";

	$attach = $wpdb->get_results($query);
	
	return _buildArray($attach);
}


function is_getAttachmentsByContent($the_content) {
	global $wpdb,$wp_query,$max_width;
	
	if ( ! is_checkPermission() ) {
		return array();
	}
	
	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	
	$query = "SELECT post_title, post_parent, post_content, post_excerpt, post_mime_type, guid, ID FROM $wpdb->posts WHERE post_type = 'attachment' AND post_content LIKE '$the_content%' ORDER BY menu_order";
//	print $query;
	$attach = $wpdb->get_results($query);
	
	return _buildArray($attach);
}


function is_getAttachmentsByExcerpt($the_excerpt) {
	global $wpdb,$wp_query,$max_width;
	
	if ( ! is_checkPermission() ) {
		return array();
	}
	
	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	
	$query = "SELECT post_title, post_parent, post_content, post_excerpt, post_mime_type, guid, ID FROM $wpdb->posts WHERE post_type = 'attachment' AND post_excerpt = '$the_excerpt' ORDER BY menu_order";
//	print $query;
	$attach = $wpdb->get_results($query);
	
	return _buildArray($attach);
}


function _buildArray($attach=array()) {
	$obj = array();

	if ( ! isset($max_width) || $max_width < 1 )
		$max_width = null;
	$obj['max-width'] = null;
	$obj['max-height'] = null;

//  split out images from other types
//	foreach ($attach as $a) {
//	foreach works on a copy of the array . as we need to modify it in the loop, 
//	use a standard for loop
	for ( $i = 0; $i < count($attach); $i++ ) {
		$a = $attach[$i];
		
		$a->src = $a->guid;
		$a->title = $a->post_title;
		$a->description = $a->post_content;
		$a->caption = $a->post_excerpt;
		$a->id = $a->ID;
		if ( isset($a->post_parent) ) {
//	get parent title and permalink
			$temp = get_post($a->post_parent);
			$a->post_parent_title = $temp->post_title;
			$a->post_parent_link = get_permalink($a->post_parent);
		}
		
//	mimetype wasn't enough here
		if ( strstr($a->post_mime_type, "video/") 
			|| strstr($a->src, ".flv") 
			|| strstr($a->src, ".mov") 
			|| strstr($a->src, ".mpg") 
		) {
			if ( strstr($a->post_mime_type, "flv") || strstr($a->src, ".flv") ) 
				$a->type = "flv";
			else if ( strstr($a->post_mime_type, "mov") || strstr($a->src, ".mov") ) 
				$a->type = "mov";
			else if ( strstr($a->post_mime_type, "mpg") || strstr($a->src, ".mpg") ) 
				$a->type = "mpg";
			else
				$a->type = $a->post_mime_type;

//	moved the discovery of poster frames / thumbnails outside this initial loop 

			if ( ! isset($obj['video'] ) ) {
				$obj['video'] = array();
				$obj['first-video'] = $a;
				$obj['firstvideo'] = $a;
			}

			array_push($obj['video'], $a);
//			print "added $i $a->type \n";
			
		} else if ( strstr($a->post_mime_type, "audio/") ) {
			if ( ! isset($obj['audio'] ) ) {
				$obj['audio'] = array();
				$obj['first-audio'] = $a;
				$obj['firstaudio'] = $a;
			}
			if ( strstr($a->post_mime_type, "mp3") || strstr($a->src, ".mp3") ) 
				$a->type = "mp3";
			else if ( strstr($a->post_mime_type, "wav") || strstr($a->src, ".wav") ) 
				$a->type = "wav";
			else
				$a->type = $a->post_mime_type;

			array_push($obj['audio'], $a);

		} else if ( strstr($a->post_mime_type, "image/") ) {
//	skip empty guid's ( for example, ones emptied by the video object above )
			if ( $a->guid == "" ) {
				continue;
			}
		
//	image specific qualities
//			$a->thumbnail = preg_replace("/\.(\w+)$/",".thumbnail.$1", $a->src);
//			$a->thumbnail = _getThumbnailURI($a->src);

//			wp2.5
			$a->meta = wp_get_attachment_metadata($a->ID);

//			$a->thumbnail = $a->meta['sizes']['medium']['file'];

//	print_r($a->meta);
//	pre 2.5 meta fails here

			if ( isset($a->meta['sizes']) ) {
				if ( isset($a->meta['sizes']['thumbnail']) )
					$a->thumbnail = $a->meta['sizes']['thumbnail']['file'];
			}
				
			if ( ! isset($a->thumbnail) ) {
				if ( isset($a->meta['thumb']) ) {
					$a->thumbnail = $a->meta['thumb'];
				} else {
					$a->thumbnail = _getThumbnailURI($a->guid);
				}
			}

			if ( isset($a->meta['sizes']) )
				if ( isset($a->meta['sizes']['medium']) )
				$a->medium = $a->meta['sizes']['medium']['file'];
			
//			print_r($a->thumbnail);
//	this might include root, so remove that 
			if ( strstr($a->thumbnail, $_SERVER['DOCUMENT_ROOT']) ) {
				$a->thumbnail = substr($a->thumbnail, 0, size($_SERVER['DOCUMENT_ROOT']));
			}

//	more likely its only the filename, so extract the path from the $a->src
			if ( ! strstr($a->thumbnail, "/") ) {
				$dir = $a->src;
				$last = strrpos($a->src, "/") + 1;
				$a->thumbnail = substr_replace($a->src, $a->thumbnail, $last);
			}

			if ( isset($a->medium) && ! strstr($a->medium, "/") ) {
				$dir = $a->src;
				$last = strrpos($a->src, "/") + 1;
				$a->medium = substr_replace($a->src, $a->medium, $last);
			}
			
			$a->sizes = is_getImageSizes($a->ID, $max_width);

			if ( $a->sizes['width'] > $obj['max-width'] )
				$obj['max-width'] = $a->sizes['width'];
				
			if ( $a->sizes['height'] > $obj['max-height'] )
				$obj['max-height'] = $a->sizes['height'];
				
			if ( strstr($a->post_mime_type, "jpeg") ) 
				$a->type = "jpg";
			else
				$a->type = $a->post_mime_type;
//	create the images array
			if ( ! isset($obj['images']) ) {
				$obj['images'] = array();
//	convenience link to first image
				$obj['first-image'] = $a;
				$obj['first'] = $a;
				$obj['firstimage'] = $a;
			}
			array_push($obj['images'], $a);
        } else {
			if ( ! isset($obj['other'] ) )
				$obj['other'] = array(); 
			if ( strstr($a->post_mime_type, "pdf") ) 
				$a->type = "pdf";
			else
				$a->type = $a->post_mime_type;			
			array_push($obj['other'], $a);
        }
    }
    
//	this is all new in 0.59 - abstracted out of the original method which was flakey and hard to understand 
    if ( is_array($obj['video']) && is_array($obj['images']) ) {			
		for ( $i = 0; $i < count($obj['video']); $i++ ) {
//	look throught the images array for captions (excerpts) that match video sources (guids)
			for ( $j = 0; $j < count($obj['images']); $j++ ) {
				$found = false;
				
//	this will override src matching ( captions are prioritised )
				if ( ! empty($obj['images'][$j]->caption) ) {
//	does the image caption match the video src ?
					if ( strstr($obj['video'][$i]->src, $obj['images'][$j]->caption) ) {
						$found = true;
						$found_id = $j;
					}
				}

//	if a thumbnail hasn't already been set AND the src of the video and image match ( excepting their extensions ) 
				if ( empty($obj['video'][$i]->thumbnail) && strlen($obj['images'][$j]->src) >= strlen($obj['video'][$i]->src) ) {
					_debug('comparing' . $obj['images'][$j]->src . " : " . $obj['video'][$i]->src);
					_debug(substr_compare($obj['images'][$j]->src, $obj['video'][$i]->src, 0, strlen($obj['video'][$i]->src) - 3));
					if ( substr_compare($obj['images'][$j]->src, $obj['video'][$i]->src, 0, strlen($obj['video'][$i]->src) - 3) >= 0) {
						$found = true;
						$found_id = $j;
					}
				}

				if ( $found ) {
					$obj['video'][$i]->thumbnail = $obj['video'][$i]->image = $obj['video'][$i]->poster = $obj['images'][$j]->src;
				}
			}	

//	now try and get rid of the image that is a poster for this video
			if ( $found_id >= 0 ) {
//				unset($obj['images'][$found_id]);
				array_splice($obj['images'], $found_id, 1);
			}
		}


		
		$obj['firstvideo'] = $obj['first-video'] = $obj['video'][0];
		$obj['first'] = $obj['firstimage'] = $obj['first-image'] = $obj['images'][0];
	}
			


/*
    echo "<!--
    ";
    print_r($obj);
    print_r($attach);
    echo "
    -->";
*/
    return $obj;
    
}

/**
* Scans the specified directory and returns an array of images.
*
* Returns results in a similar format to is_getAttachments, but instead scans the specified directory, automatically generating thumbnails along the way.
* @param string $images_dir
* @author mr.snow
* @see is_getAttachments
* @todo
*/
function is_getImagesFromDirectory($images_dir=null) {
	global $wp_query, $is_config;

	if ( ! is_checkPermission() ) {
		return array();
	}
	
	$is_config = get_option('is_config');	
	
//	variables from config
//	$th_w = $is_config['thumbnail_w'];
//	$th_h = $is_config['thumbnail_h'];
	
	$th_w = $is_config['sizes']['thumbnail']['width'];	
	$th_h = $is_config['sizes']['thumbnail']['height'];
	
	if ( $is_config['th_type'] == 'fill' ) {
		$fill = true;
	} else if ( $is_config['th_type'] == 'crop' ) {
		$crop = true;
	}
	
	$post_name = '';
	if ( ! isset($images_dir) ) {
		$post_obj = $wp_query->get_queried_object();
		$post_name = $post_obj->post_name;
		$images_dir = $is_config['auto_directory'] . $post_name;		
		_debug($images_dir);
	}
	
	$dir = $_SERVER['DOCUMENT_ROOT'] . "/" . $images_dir;
	
	$obj = array();
//	$obj['images'] = array();
	$temp = array();

	if (is_dir($dir)) {
		if ($dh = opendir($dir)) {
			while (($file = readdir($dh)) !== false) {
				if (substr($file, 0, 1) == '.')
					continue;
				else if (strstr($file, "thumbnail"))
					continue;
					
				array_push($temp, $file);
			}
			closedir($dh);
		}
	}
	
	sort($temp);
	
	foreach ( $temp as $file ) {
	
				$a = new stdClass;
				$a->filename = $file;
				$a->src = $images_dir . "/" . $file;
				$a->guid = $a->src;
				$a->path = $_SERVER['DOCUMENT_ROOT'] . "/" . $images_dir . "/" . $file;

//				$a->thumbnail = preg_replace("/\.(\w+)$/",".thumbnail.$1", $a->src);
				$a->thumbnail = _getThumbnailURI($a->src, false, $post_name);
//				$a->thumbnailpath = $_SERVER['DOCUMENT_ROOT'] . "/" . $a->thumbnail;
				$a->thumbnailpath = _getThumbnailURI($a->src, true, $post_name);
				
//	get image size
				$a->info = getimagesize($a->path);
				$a->width = $a->info[0];
				$a->height = $a->info[1];
				$a->type = $a->info['mime'];

				if ( strstr($a['info']['mime'], "png") ) {
					$a['type'] = 'png';
				} else if ( strstr($a['info']['mime'], "jpeg") ) {
					$a['type'] = 'jpg';
				}
				
//	test to see if thumbnail exists, if not, create
				if ( ! file_exists($a->thumbnailpath) ) {
					_debug("Creating " . $a->thumbnailpath);
					_debug("$a->path, $a->thumbnailpath, $a->width, $a->height, $th_w, $th_h, $fill, $crop");

					if ( $crop )
						$fill = $crop;
					if ( $a->height ) {
						resizeThumbnail($a->path, $a->thumbnailpath, $a->width, $a->height, $th_w, $th_h, $fill, $crop);
					} else {
//						print_r($a);
//						print_r(getimagesize($a->path));
					}
				}
				
				if ( ! $obj['images'] ) {
					$obj['images'] = array();
//	convenience link to first image
					$obj['first-image'] = $a;
					$obj['first'] = $a;
					$obj['firstimage'] = $a;
				}
				
				array_push($obj['images'], $a);
	}
	
//	_debug($obj);
	return $obj;
}



	function is_getImageSizes($id, $max_width=100000) {		
		$size = array();
		$metadata = wp_get_attachment_metadata($id);
		
//		print_r($image_meta);
		
		if ( (int) $metadata['width'] > $max_width ) {
			$ratio = $max_width / $metadata['width'];
			$height = (int) ( $metadata['height'] * $ratio );
			if ( isset ( $height ) ) 
				$size['width'] = $max_width;
				$size['height'] = $height;
		} else {
			$size['width'] = $metadata['width'];
			$size['height'] = $metadata['height'];

			if ( $metadata['hwstring_small'] ) {
				$string = $metadata['hwstring_small'];
				ereg("height='([[:alnum:]]+)' width='([[:alnum:]]+)'", $string, $regs); 
				
				$size['thumbnail_w'] = $regs[2];
				$size['thumbnail_h'] = $regs[1];
			}
		}
		
		return $size;
	}



function resizeThumbnail($src, $dest, $w, $h, $th_w, $th_h, $fill=false, $crop=false) {
	require_once('gd.php');
	$img = Image_Transform::factory('GD');
//	open the original
	$img->load($src);

	$new_width = $th_w;
	$new_height = $th_h;

	$ratio = $w / $h;
					
	if ( $ratio > 1 ) {
		if ( $fill )
			$new_width = $th_h * $ratio;
		else
			$new_height = $th_w / $ratio;
	} else {
		if ( $fill )
			$new_height = $th_w / $ratio;
		else
			$new_width = $th_h * $ratio;
	}
	
					
	if( $img->resize($new_width, $new_height) ) {
//	save it to the thumbnail
		$img->save($dest);
	} else {
		echo "Error resizing " . $src;
	}
					
	if ( $crop ) {
		$new_x = ( $new_width - $th_w ) / 2;
		$new_y = ( $new_height - $th_h ) / 2;
		
		if ( $img->crop($new_x, $new_y, $th_w, $th_h) ) {
			$img->save($dest);
		} else {
			echo "Error cropping " . $src;
		}
	}
}


function is_check_config() {
//	exit;

	if ( !$option = get_option('is_config') ) {

		$option['thumbnail_w'] = get_option('thumbnail_size_w');
		$option['thumbnail_h'] = get_option('thumbnail_size_h');
		$option['medium_w'] = $option['sizes']['medium']['width'];
		$option['medium_h'] = $option['sizes']['medium']['height'];
		$option['th_type'] = "";
		$option['medium_type'] = "";
		$option['parent'];
		$option['menu_order'];
		$option['auto_directory'] = "/wp-content/uploads/";
		
		update_option('is_config', $option);
	}
	
	if ( ! is_array($option['sizes']) ) {
		$option['sizes']['thumbnail']['width'] = get_option('thumbnail_size_w');
		$option['sizes']['thumbnail']['height'] = get_option('thumbnail_size_h');
		$option['sizes']['medium']['width'] = get_option('medium_size_w');
		$option['sizes']['medium']['height'] = get_option('medium_size_h');

		update_option('is_config', $option);
	}
	
//		print_r($option);
//		exit;
	
}


function is_options_submit() {

	if ( current_user_can('level_10') ) {

		//options page
//		$option['size'] = $_POST['size'];
		$option['thumbnail_w'] = $_POST['thumbnail_w'];
		$option['thumbnail_h'] = $_POST['thumbnail_h'];
		$option['th_type'] = $_POST['th_type'];
		$option['parent'] = $_POST['parent'];
		$option['menu_order'] = $_POST['menu_order'];
		$option['auto_directory'] = $_POST['auto_directory'];
		
		update_option('is_config', $option);

		if ( get_bloginfo('version') >= 2.5 ) {
			$option['medium_w'] = $_POST['medium_w'];
			$option['medium_h'] = $_POST['medium_h'];
			$option['medium_type'] = $_POST['medium_type'];

			$option['sizes']['thumbnail']['width'] = $_POST['thumbnail_w'];
			$option['sizes']['thumbnail']['height'] = $_POST['thumbnail_h'];
			$option['sizes']['medium']['width'] = $_POST['medium_w'];
			$option['sizes']['medium']['height'] = $_POST['medium_h'];

			update_option('is_config', $option);

//		update internal wp options too 
			update_option('thumbnail_size_w', $_POST['thumbnail_w']);
			update_option('thumbnail_size_h', $_POST['thumbnail_h']);
//			update_option('thumbnail_crop'));
			update_option('medium_size_w', $_POST['medium_w']);
			update_option('medium_size_h', $_POST['medium_h']);


/*
form_option('thumbnail_size_w');
form_option('thumbnail_size_h');
get_option('thumbnail_crop'));
form_option('medium_size_w'); 
form_option('medium_size_h'); 
*/
		}
	}

}



//	edit-attachment-rows.php
//			<td class="media-icon"><php echo wp_get_attachment_link($post->ID, array(80, 60), false, true); ></td>

/*	post-template.php
function wp_get_attachment_link($id = 0, $size = 'thumbnail', $permalink = false, $icon = false) {
	$_post = & get_post( intval($id) );

	if ( ('attachment' != $_post->post_type) || !$url = wp_get_attachment_url($_post->ID) )
		return __('Missing Attachment');

	if ( $permalink )
		$url = get_attachment_link($_post->ID);

	$post_title = attribute_escape($_post->post_title);

	$link_text = wp_get_attachment_image($id, $size, $icon);
	if ( !$link_text )
		$link_text = $_post->post_title;

	return "<a href='$url' title='$post_title'>$link_text</a>";

*/

/*	post.php
function wp_get_attachment_url( $post_id = 0 ) {
	return apply_filters( 'wp_get_attachment_url', $url, $post->ID );

*/

/*	link-template.php
function get_attachment_link($id = false) {
	...
	return apply_filters('attachment_link', $link, $id);

*/
	
//	add_action( 'upload_files_browse', 'wp_upload_tab_browse_action' );
//	add_action( 'upload_files_browse', 'is_upload_tab_browse_action' );


	function is_fields_to_edit($form_fields, $post) {
		$form_fields = image_attachment_fields_to_edit($form_fields, $post);
		
		
//		print_r($form_fields);
/*
			$form_fields['post_title']['required'] = true;
			$form_fields['post_excerpt']['label'] = __('Caption');
			$form_fields['post_excerpt']['helps'][] = __('Alternate text, e.g. "The Mona Lisa"');

			$form_fields['post_content']['label'] = __('Description');
*/


		global $parent_array;
		if ( ! is_array($parent_array) )
			$parent_array = _get_parent_array();


		if ( is_array($parent_array) ) {
			$form_fields['post_parent'] = array(
				'label' => __('Attachment parent'),
				'input' => 'html',
				'helps' => __('With which post is this file associated?'),
				'html'  => "
					<select>
			
					</select>"
			);

			$form_fields['post_parent']['html'] = "<select id='attachments[$post->ID][post_parent]' name='attachments[$post->ID][post_parent]' style='width : 460px;'><option value='0'>Select a parent</option><option value='0'>No parent</option>";

			foreach ($parent_array as $p) {
				if ( $post->post_parent == $p->ID )
					$selected = "selected";
				else
					$selected = "";
					
				$form_fields['post_parent']['html'] .= "<option value='$p->ID' $selected>$p->post_title</option>";
			}
			$form_fields['post_parent']['html'] .= "</select>";
		}
		
//	images only		
		if ( substr($post->post_mime_type, 0, 5) == 'image' ) {
			$form_fields['image-crop'] = array();
			$form_fields['image-crop']['label'] = __('Recrop/resize');
			$form_fields['image-crop']['input'] = "html";
			$form_fields['image-crop']['helps'] = "Warning, edit 'full size' changes your originals.";
			$form_fields['image-crop']['html'] = "
			
			<input type='radio' name='attachments[$post->ID][image-crop]' id='image-crop-thumb-$post->ID' value='thumbnail' />
			<label for='image-crop-thumb-$post->ID'>Thumbnail</label>
			<input type='radio' name='attachments[$post->ID][image-crop]' id='image-crop-medium-$post->ID' value='medium' checked='checked' />
			<label for='image-crop-medium-$post->ID'>Medium</label>
			<input type='radio' name='attachments[$post->ID][image-crop]' id='image-crop-full-$post->ID' value='full' />
			<label for='image-crop-full-$post->ID'>Full size</label>
			
			<input type='button' class='button' value='Edit image' onclick='is_launchEditor(this.form, $post->ID, \"attachments[$post->ID][image-crop]\", \"" . get_bloginfo('wpurl') . "\")' />
			
			";
//				return "<a href=\"javascript:window.open('/wp-content/plugins/is_attachments/is_attachment_editor.php?id=$id', 'cropwindow', 'status=true,toolbar=false,width=760,height=400');\">$icon</a>";
			
//				$form_fields['_final'] = "oath";

		}
	
		return $form_fields;
	}


	function is_fields_to_save($post, $attachment) {
		if ( isset($attachment['post_parent']) )
			$post['post_parent'] = $attachment['post_parent'];
		return $post;
	}


	function is_attach_manage_columns($defaults) {
//		$defaults['attachments'] = __('Attachments');
//		$defaults['parent'] = __('Parent post');
		unset($defaults['parent']);
		$defaults['is_parent'] = __('Parent post');

		return $defaults;
	}


	function is_attach_manage_custom_column($column_name) {
		global $wpdb, $post, $orderposts, $parent_array;
		
		if ( ! is_array($post_array) ) {
			$parent_array = _get_parent_array();
		}
		if ( $column_name == 'is_parent' ) {
			echo "<div style='text-align : center' id='parentof_$post->ID'>" . $parent_array[$post->post_parent]->post_title . "</div>
			<script type='text/javascript'>
//	compensate for the removal of the id on the parent table ( wp 2.5 )
				is_setuptable('menuorder_$post->ID');
//				new Ajax.InPlaceEditor('menuorder_$post->ID','$orderposts/is_orderposts_update.php?container=is_single',{rows:1,cols:3, callback: function(form, value) { return '$post->ID=' + escape(value) }});
			</script>
			";
		}
	}


	function _get_parent_array() {
		global $wpdb;
		$results = array();

		$post_titles = "SELECT post_title, ID FROM $wpdb->posts WHERE post_type != 'attachment' AND post_type != 'revision' ORDER BY post_title";
		$results =  $wpdb->get_results($post_titles);

		return $results;
	}

//function is_upload_attachment_link($link, $id=null) {
function is_upload_attachment_icon($icon, $id=null) {
print $icon; exit;
//	return apply_filters( 'attachment_icon', $icon, $post->ID );
//	return $link;
//	c = window.open('/wp-content/plugins/is_attachments/is_attachment_editor.php?id=' + the_id, 'cropwindow', 'status=true,toolbar=false,width=760,height=400');
	return "<a href=\"javascript:window.open('/wp-content/plugins/is_attachments/is_attachment_editor.php?id=$id', 'cropwindow', 'status=true,toolbar=false,width=760,height=400');\">$icon</a>";
}

//	if ( !empty($form_fields['_final']) )
//		<tr><td>" . apply_filters('media_meta', '', $post) . "</tr></td>



function is_attach_media_meta($args) {
	return $args;
}


function is_upload_tabs($wp_upload_tabs) {
	global $all_atts, $post_atts, $action;
	
//	$wp_upload_tabs['browse'] = array(__('Browse'), 'upload_files', "wp_upload_tab_browse", $action ? 0 : $post_atts);
	$wp_upload_tabs['browse'] = array(__('Browse'), 'upload_files', "is_upload_tab_browse", 0);
//	$wp_upload_tabs['browse-all'] = array(__('Browse All'), 'upload_files', "is_upload_tab_browse_all", 0);
//	print_r($wp_upload_tabs['browse-all']);
//	exit;
	$wp_upload_tabs['browse-all'] = array(__('Browse All'), 'upload_files', 'is_upload_tab_browse_all', $action ? 0 : $all_atts);
//	$wp_upload_tabs['browse-all'] = array(__('Browse All'), 'upload_files', 'is_upload_tab_browse_all');
//	$atts = $wp_upload_tabs['browse-all'][4];
//	$wp_upload_tabs['browse-all'] = array(__('Browse All'), 'upload_files', 'is_upload_tab_browse_all', $atts);
	return $wp_upload_tabs;
}


function is_upload_tab_browse() {

    wp_upload_tab_browse();
	is_upload_tab_browse_action();

}


function is_upload_tab_browse_all() {

	wp_upload_tab_browse();
	is_upload_tab_browse_action();

}


function js_includes() {

	wp_enqueue_script('cropper');
	wp_enqueue_script('colorpicker');

}


function is_thumbnail_max_side_length($size, $id, $filename){
	global $is_config;

	$thumbnail_w = $is_config['thumbnail_w'];
	$thumbnail_h = $is_config['thumbnail_h'];
	$th_type = $is_config['th_type'];
	
	if ( $square != "true" ) {
		return $size;
	}
	
	$info = getimagesize($filename);
	
	if ( $info[0] > $info[1] ) {
		$size = $info[0] / $info[1] * $is_config['size'];
	} else {
		$size = $info[1] / $info[0] * $is_config['size'];
	}

	return (int)$size;
}


function is_checkPermission() {
	global $wp_query;
	$post_obj = $wp_query->get_queried_object();

//	a protected post, return nothing	
	if ( !empty($post_obj->post_password) && $_COOKIE['wp-postpass_'.COOKIEHASH] != $post_obj->post_password) {
		return false;
	} else {
		return true;
	}
}


function _getThumbnailURI($image, $path=false, $auto=false) {

//	pre wp2.5
	$thumb = preg_replace("/\.(\w+)$/",".thumbnail.$1", $image);
//	post wp2.5

	if ( $auto ) {
//	this is for auto directory thumbnailing . thumbnails now go into the special
//	/wp-content/uploads/_thumbnails/ directory regardless of settings .
		$thumb_dir = "/wp-content/uploads/_thumbnails_is/$auto";

		if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . $thumb_dir)) {
			mkdir($_SERVER['DOCUMENT_ROOT'] . $thumb_dir, 0777);
		}
		$thumb = preg_replace("/.+\/(.+?)\/(.+?)\.(\w+)$/", $thumb_dir . "/$2.thumbnail.$3", $image);
	}
	
//	if the file doesnt exist, then use the full image instead ( unless we're auto thumbnailing )
	if ( ! $auto && ! file_exists($_SERVER['DOCUMENT_ROOT'] . "/" . $thumb) ) {
		$thumb = $image;
	}
	
	
	if ( ! $path ) {
		return $thumb;
	} else {
		return $_SERVER['DOCUMENT_ROOT'] . "/" . $thumb;
	}

}





function is_upload_tab_browse_action() {
	global $wpdb, $post_id;
//	wp_enqueue_script('prototype');
	js_includes();
    $id = get_the_ID();

//	try getting the id from the location.href instead
//	$id = $_SERVER['QUERY_STRING'];
//	$id = preg_replace("/.*ID=(\d+).*/","$1", $id);
	

//  is this only returning the first attachment ?
	$attachment = get_post_to_edit($id);
//	print_r($attachment);
//	$attachment_data = wp_get_attachment_metadata($id);

//	$post_parent = $post_id;
	$post_parent = $attachment->post_parent;
	if ( ! isset($post_parent) ) {
		$post_parent = -1;
	}
	
//	$menu_order = $attachment_data['menu_order'];
	$menu_order = $attachment->menu_order;
//    echo "<script>alert(" . $attachment->ID . ")</script>";
	if ( ! isset($menu_order) ) {
		$menu_order = 0;
	}

	$post_titles = "SELECT post_title, ID FROM $wpdb->posts WHERE post_type != 'attachment' ORDER BY post_title";
	$post_titles =  $wpdb->get_results($post_titles);

	$menu_orders = "SELECT menu_order,post_parent,ID FROM $wpdb->posts WHERE post_type = 'attachment' ORDER BY menu_order";
	$menu_orders =  $wpdb->get_results($menu_orders);

	echo "<script type='text/javascript'>
	<!--
		
		existing_posts = new Object();
		existing_attachments = new Array();
			
	";
		
	foreach ( $post_titles as $pt ) {
		echo "\t\t\texisting_posts[" . $pt->ID . "] = \"" . $pt->post_title . "\";\n";
	}
		
	foreach ( $menu_orders as $pt ) {
		echo "\t\t\texisting_attachments[" . $pt->ID . "] = new Object();\n";
		echo "\t\t\texisting_attachments[" . $pt->ID . "].order = \"" . $pt->menu_order . "\";\n";
		echo "\t\t\texisting_attachments[" . $pt->ID . "].parent = \"" . $pt->post_parent . "\";\n";
	}
		
	echo "//--></script>";


?>
	<style type='text/css'>
	<!--
		#is_cropper {
			position : absolute;
			top : 10px;
			left : 10px;
			width : 200px;
			height : 300px;
			border : solid 1px red;
			background-color : #eeeeee;
		}
	//-->
	</style>
	
	<script type='text/javascript'>
	<!--
	
		function is_append_to_browse_form() {

			node = document.getElementById('upload-file-view');
			id_node = document.getElementById('file-title');
//			alert(id_node.childNodes[2].childNodes[0].onclick)
			id_str = escape(id_node.childNodes[2].childNodes[0].onclick);
//  get the number between the last pair of ()
            start = id_str.lastIndexOf(escape("("));
            stop = id_str.lastIndexOf(escape(")"));
            the_id = parseInt(id_str.substring(start+escape("(").length,stop));

/*            			
			q = location.query;
			temp = q.split("&");
			for ( i = 0; i < temp.length; i ++ ) {
				if ( temp[i].toLowerCase().indexOf("id=") == 0 ) {
					the_id = temp[i].substring(3, temp[i].length);
					alert(the_id)
				}
			}
*/          			
			h = "";
			
			h += "<tr>";
			h += "<th scope='row'><label for='post_parent'>Parent<\/label><\/th>";
			h += "<td><select name='post_parent' style='width : 300px;' id='post_parent'>";
			h += "<option value='0'>No post<\/option>";
			
			h += "<option value='" + <?php echo $post_id; ?> + "'>This post [" + <?php echo $post_id; ?> + "]<\/option>";
			
			for ( key in existing_posts ) {
				selected = "";

				if ( key == existing_attachments[the_id].parent ) {
					selected = " selected ";
				}
				
				if ( existing_posts[key] == "" )
					existing_posts[key] = "[Post " + key + "]";
				
				h += "<option value='" + key + "'" + selected + ">" + existing_posts[key] + "<\/option>";
			}
			
			h += "<\/select>";

			h += "<label for='menu_order' style='padding-left : 20px; padding-right : 5px; font-weight : bold; width : 20%;'>Order<\/label>";
			h += "<input id='menu_order' name='menu_order' type='text' value=" + existing_attachments[the_id].order + " style='width : 40%;' /><\/td><\/tr>";
			
			new Insertion.Before('buttons', h);
			
			if ( node.childNodes ) {
				for ( i = 0; i < node.childNodes.length; i++ ) {
					if ( node.childNodes[i].src ) {
						node = node.childNodes[i];
						break;
					}
				}
			}
//			alert(node.parentNode.id)
//			node = node.parentNode;
//	who knows when it should be parent or not ?
			node.title = "Click to re-crop";
			node.onclick = function() {

//	open another window or a div with image to crop
//				c = window.open('/wp-content/plugins/is_attachments/is_attachment_editor.php?id=' + the_id, 'cropwindow', 'status=true,toolbar=false,width=760,height=400');
				c = window.open('/wp-content/plugins/is_attachments/is_attachment_editor.php?id=' + the_id, 'cropwindow', 'resizable=1,status=true,toolbar=false,width=760,height=400');
//	could be either crop for new thumbnail 

				
//	( should check minimum size, so that its not enlarging )
//	or could be full image crop
//	lets try making a div
								
//	return false means that the a href isnt called
				return false;
			}
		}
		
		
		watch();
		var t;
		
		function watch() {
			clearTimeout(t);
			if ( ! document.getElementById('post_content') ) {
				t = setTimeout("watch()", 100);
				if ( window.status == '' )
					window.status = "/";
				else if ( window.status == "/" )
					window.status = "-";
				else if ( window.status == "-" )
					window.status = "\\";
				else if ( window.status == "\\" )
					window.status = "|";
				else if ( window.status == "|" )
					window.status = "/";
			} else {
				is_append_to_browse_form();
			}
		}
		
	//-->
	</script>
	

<?php
 

}


	function array_remove (&$arr, $index) {
		if ( isset($arr[$index]) ) {
			array_splice($arr, $index, 1);
		}
	}
	
	function _debug($msg) {
		if ( $_REQUEST['debug'] ) {
			print "<pre>";
//			if ( is_array($msg) )
				print_r($msg);
//			else
//				print $msg;
			print "</pre>";
		}
		return;
	}
	
	
//	add_action('admin_print_scripts', 'is_admin_print_scripts');
	add_action('admin_menu', 'is_Attachments');

	add_filter('wp_upload_tabs', 'is_upload_tabs');
	add_filter('media_meta','is_attach_media_meta');
	add_filter('wp_thumbnail_max_side_length', 'is_thumbnail_max_side_length', 10, 3);

	if ( is_admin() ) {
		add_filter('attachment_fields_to_edit', 'is_fields_to_edit', 10, 4);
		add_filter('attachment_fields_to_save', 'is_fields_to_save', 10, 4);
		wp_enqueue_script("is_attachments", get_bloginfo('wpurl') . "/wp-content/plugins/is_attachments/is_attachments.js", array("prototype"), 0.1);
	}

	if ( isset($_POST['is_submit_options']) ) 
		add_action('init', 'is_options_submit'); //Update Options 

?>