//	is_attachment_editor.js
//	copyright mr.snow@laudanum.net

			var image_size = null;
	
			function submitForm(obj) {
				makeSelection(obj);
				obj.submit();
				return false;
			}


			function updateForm(obj) {
			
				if ( document.getElementById('image_size_thumbnail').checked )
					ratio = th_ratio;
				else if ( document.getElementById('image_size_medium').checked )
					ratio = th_ratio;
				else
					ratio = full_ratio;
			
				makeSelection();
				updateTargetSize();
				
				return false;
			}
			
			
			function updateTargetSize() {
				image_size = getSize();

				if (sizes[image_size]) {
					document.getElementById('target_w').innerHTML = sizes[image_size]['width'];
					document.getElementById('target_h').innerHTML = sizes[image_size]['height'];
				}
			}
			
			
			function getSize() {
				return getCheckedValue(document.forms[0], 'image_size');
			}


			function captureStart(e) {
				getMouseXY(e);
   			    x1 = x - margin_x;
			    y1 = y - margin_y;
			    document.onmousemove = processCoords;
			    document.onmouseup = captureStop;
			    return false;
			}


			function captureStop() {
			    sx = -1; sy = -1;

				action = 'make';
			    document.onmousemove = null;
			    return false;
			}
			
			
			function processCoords(e) {
				getMouseXY(e);
//				window.status = action;
				
   			    x2 = x - margin_x;
			    y2 = y - margin_y;

//				node = document.getElementById('target');
				
				if ( x2 > max_x )
					x2 = max_x;
				if ( x2 < 0 )
					x2 = 0;
				
				if ( y2 > max_y )
					y2 = max_y;
				if ( y2 < 0 )
					y2 = 0;
				
				mdirection = '';
				
				if ( x1 > x2 ) {
					l = x2;
					w = x1 - x2;
					mdirection += 'w';
				} else {
					l = x1;
					w = x2 - x1;
					mdirection += 'e';
				}
				
				if ( y1 > y2 ) {
					t = y2;
					h = y1 - y2;
					mdirection += 'n';					
				} else {
					t = y1;
					h = y2 - y1;
					mdirection += 'n';	
				}
				
				if ( w < 2 )
					w = 2;
				if ( h < 2 )
					h = 2;
				
				
				if ( action == 'make' ) {

					if ( ! mdirection ) {
					mdirection = '';
					if ( dx > 5) 
						mdirection += 'e';
					else if ( dx < -5 )
						mdirection += 'w'
					if ( dy > 5 ) 
						mdirection += 's';
					else if ( dy < -5 )
						mdirection += 'n';
					}
					window.status = mdirection;
					
					document.getElementById('width').value = w ;
					document.getElementById('height').value = h;
					document.getElementById('top').value = t;
					document.getElementById('left').value = l;
/*
					if ( document.getElementById('constrain').checked ) {
						if ( mdirection.indexOf('s') > -1 )
							document.getElementById('height').value = parseInt(document.getElementById('width').value / ratio);
						else {
							oldbottom = parseInt(document.getElementById('height').value) + parseInt(document.getElementById('top').value);
							document.getElementById('height').value = parseInt(document.getElementById('width').value / ratio);
							document.getElementById('top').value = oldbottom - document.getElementById('height').value;
						}			
					}
*/

					makeSelection();


/*
					document.getElementById('top').value = t;
					document.getElementById('left').value = l;
					resizeSelection(e, direction);
*/
				} else if ( action == 'resize' ) {
					resizeSelection(e, direction);
				} else if ( action == 'move' ) {
					moveSelection();
				}
			}
			
			function makeSelection() {
			
				conformSelection();
		//		margin = 2
				margin = 0
				selection = document.getElementById('selection');
				if ( ! selection ) {
					node = document.getElementById('target');
					selection = document.createElement('div');
					selection.id = 'selection';
					selection.onmousedown = startMove;
					selection.onmouseup = stopMove;
					node.appendChild(selection);

					compass = Array('nw','n','ne','e','se','s','sw','w');
					for ( i = 0; i < compass.length; i++ ) {
						eval("control_" + compass[i] + " = document.createElement('div')");
						eval("control_" + compass[i] + ".id = 'control_" + compass[i] + "'");
						eval("control_" + compass[i] + ".className = 'controlhandle'");
						eval("control_" + compass[i] + ".onmousedown = resizeSelection_" + compass[i]);
						eval("selection.appendChild(control_" + compass[i] + ")");
					}
				}

				selection.style.top = parseInt(document.getElementById('top').value) + 'px';
				selection.style.left = parseInt(document.getElementById('left').value) + 'px';
				selection.style.width = parseInt(document.getElementById('width').value - margin) + 'px';
				selection.style.height = parseInt(document.getElementById('height').value - margin) + 'px';
				
			}


			function resizeSelection(e, direction) {
//	window.status = direction;

				if ( direction.indexOf('w') > -1 ) {
					x2 = parseInt(selection.style.left) + parseInt(dx);
					w = parseInt(selection.style.width) - parseInt(dx);
				
					if ( w < 2) return false;
					if ( x2 < 0 ) return false;

					document.getElementById('left').value = x2;
					document.getElementById('width').value = w;
				
				} else if ( direction.indexOf('e') > -1 ) {
					w = parseInt(selection.style.width) + parseInt(dx);

					if ( parseInt(selection.style.left) + w > max_x ) return false;

					document.getElementById('width').value = w;
				}

				if ( document.getElementById('constrain').checked ) {
//	is the new selection closer to the actual width or not ?
//					if ( Math.abs(document.getElementById('width').value - default_w) < Math.abs(document.getElementById('height').value - default_h)) {
					if ( direction.indexOf('s') > -1 )
						document.getElementById('height').value = parseInt(document.getElementById('width').value / ratio);
					else {
						oldbottom = parseInt(document.getElementById('height').value) + parseInt(document.getElementById('top').value);
						document.getElementById('height').value = parseInt(document.getElementById('width').value / ratio);
						document.getElementById('top').value = oldbottom - document.getElementById('height').value;
					}
					makeSelection();
					return;
					
				}

				if ( direction.indexOf('n') > -1 ) {
					y2 = parseInt(selection.style.top) + parseInt(dy);
					h = parseInt(selection.style.height) - parseInt(dy);
				
					if ( h < 2) return false;
					if ( y2 < 0 ) return false;

					document.getElementById('top').value = y2;
					document.getElementById('height').value = h;
				
				} else if ( direction.indexOf('s') > -1 ) {
					h = parseInt(selection.style.height) + parseInt(dy);

					if ( parseInt(selection.style.top) + h > max_y ) return false;

					document.getElementById('height').value = h;				
				}
	
				if ( ! image_size )
					image_size = getSize();

			//	conformSelection();
				makeSelection();
			}
			
			
			function resizeSelection_nw(e) {
				action = 'resize';
				direction = 'nw';
			}
			
						
			function resizeSelection_n(e) {
				action = 'resize';
				direction = 'n';
			}
			
						
			function resizeSelection_ne(e) {
				action = 'resize';
				direction = 'ne';
			}
			
						
			function resizeSelection_e(e) {
				action = 'resize';
				direction = 'e';
			}
			
						
			function resizeSelection_se(e) {
				action = 'resize';
				direction = 'se';
			}
			
						
			function resizeSelection_s(e) {
				action = 'resize';
				direction = 's';
			}
			
						
			function resizeSelection_sw(e) {
				action = 'resize';
				direction = 'sw';
			}
			
						
			function resizeSelection_w(e) {
				action = 'resize';
				direction = 'w';
			}
			
						
			function moveSelection() {
				selection = document.getElementById('selection');
				
				x2 = parseInt(selection.style.left) + parseInt(dx);
				y2 = parseInt(selection.style.top) + parseInt(dy);
				
				document.getElementById('left').value = x2;
				document.getElementById('top').value = y2;
				
				conformSelection();
				
				selection.style.left = document.getElementById('left').value + 'px';
				selection.style.top = document.getElementById('top').value + 'px';
				
				return false;
			}


			function conformSelection() {
				if ( document.getElementById('left').value < 0 )
					document.getElementById('left').value = 0;

				if ( document.getElementById('top').value < 0 )
					document.getElementById('top').value = 0;
					
				if ( document.getElementById('width').value < 2 )
					document.getElementById('width').value = 2;

				if ( document.getElementById('height').value < 2 )
					document.getElementById('height').value = 2;

				if ( parseInt(document.getElementById('width').value) + parseInt(document.getElementById('left').value) >= max_x )
					document.getElementById('left').value = max_x - parseInt(document.getElementById('width').value);

				if ( parseInt(document.getElementById('width').value) + parseInt(document.getElementById('left').value) >= max_x )
					document.getElementById('width').value = max_x - parseInt(document.getElementById('left').value);

				if ( parseInt(document.getElementById('width').value) >= max_x )
					document.getElementById('width').value = max_x;

				if ( parseInt(document.getElementById('height').value) + parseInt(document.getElementById('top').value) >= max_y )
					document.getElementById('top').value = max_y - parseInt(document.getElementById('height').value);

				if ( parseInt(document.getElementById('height').value) + parseInt(document.getElementById('top').value) >= max_y )
					document.getElementById('height').value = max_y - parseInt(document.getElementById('top').value);

				if ( parseInt(document.getElementById('height').value) >= max_y )
					document.getElementById('height').value = max_y;

				if ( document.getElementById('left').value < 0 )
					document.getElementById('left').value = 0;

				if ( document.getElementById('top').value < 0 )
					document.getElementById('top').value = 0;
					
//				window.status = document.getElementById('width').value;
				if ( ! image_size )
					image_size = getSize();
			
				if (sizes[image_size]) {
					if ( document.getElementById('width').value < sizes[image_size]['width'] || document.getElementById('height').value < sizes[image_size]['height'] ) {

//						window.status = ('warning - will enlarge image' );
//	Effect.Appear(imgs[i+1].id, { duration: 0.5, queue: 'end' });
						document.getElementById('size_warning').style.display = 'block';
						
//						window.status = document.getElementById('width').value / sizes[image_size]['width'];
						
//						if ( document.getElementById('width').value / sizes[image_size]['width'] > 0.8 || document.getElementById('height').value / sizes[image_size]['height'] > 0.8 )
//							document.getElementById('size_warning').style.backgroundColor = 'pink';
//						else
//							document.getElementById('size_warning').style.backgroundColor = 'red';

						dw = document.getElementById('width').value / sizes[image_size]['width'];
						dh = document.getElementById('height').value / sizes[image_size]['height'];
						if ( dw < dh ) 
							d = dw;
						else
							d = dh;
							
						d = mixPalette('ffffff','ff0000',d);
//						window.status = d.text;

						document.getElementById('size_warning').style.backgroundColor = d.text;

//						Effect.Appear('size_warning', { duration : 0.5, queue : 'end' });
					} else {
						document.getElementById('size_warning').style.display = 'none';
//						Effect.Fade('size_warning', { duration : 0.5, queue : 'end' });
					
					}
				}
			}
			
			
			function centreSelection() {
			
				document.getElementById('left').value = parseInt((max_x - document.getElementById('width').value) / 2);
				document.getElementById('top').value = parseInt((max_y - document.getElementById('height').value) / 2);
				makeSelection();
				
			}


			function maximizeSelection(w,h) {

//	w,h is the size of the full image
//	restrict its aspect ratio
				max_r = w/h;
				if ( ! sizes[image_size] ) {
					_error('image_size');
					return;
				}
					
				tmp_r = sizes[image_size]['width'] / sizes[image_size]['height'];

//	make a selection based on that
				if ( max_r < tmp_r ) {
					document.getElementById('left').value = 0;
					document.getElementById('width').value = w;

					document.getElementById('height').value = parseInt(w * tmp_r);
					document.getElementById('top').value = parseInt((h - document.getElementById('height').value) / 2);
				} else {
					document.getElementById('width').value = parseInt(h * tmp_r);
					document.getElementById('left').value = parseInt((w - document.getElementById('width').value) / 2);
					document.getElementById('top').value = 0;
					document.getElementById('height').value = h
				}					
				makeSelection();
				
			}


			function setSelectionTo(nt, nl, nw, nh) {
				if ( nt ) 
					document.getElementById('top').value = nt;
				if ( nl )
					document.getElementById('left').value = nl;
				if ( nw )
					document.getElementById('width').value = nw;
				if ( nh )
					document.getElementById('height').value = nh;
				makeSelection();		
			}


			function getMouseXY(event) {

			    dx = x;
			    dy = y;
			    
			    x = ns6? e.clientX:event.clientX;
			    y = ns6? e.clientY:event.clientY;
			    
//			    document.getElementById('x').value = x;
//			    document.getElementById('y').value = y;
    
    			dx = x - dx;
    			dy = y - dy;
    			
//			    document.getElementById('dx').value = dx;
//			    document.getElementById('dy').value = dy;

			    return false;

			}
			
			
			function startResize() {
				action = 'resize';
			}

			
			function stopResize() {
				action = 'resize';
				document.onmouseup = captureStop;
			}


			function startMove() {
				if ( action != 'resize' )
					action = 'move';
			}


			function stopMove() {
				action = 'resize';
				document.onmouseup = captureStop;
			}
			
			
			function getCheckedValue(f,n) {
				arr = f[n];
				for ( i = 0; i < arr.length; i++ ) {
					if ( arr[i].checked )
						return arr[i].value;
				}
				return null;
			}


var colType = 'hex';
var base = 16;
	
			
function Color(r,g,b) {
	this.r = r;
	this.g = g;
	this.b = b;
	this.coll = new Array(r,g,b);
	this.valid = cVerify(this.coll);
	this.text = cText(this.coll);
	this.bg = cText(this.coll);
}

function cVerify(c) {
	var valid = 'n';
	if ((!isNaN(c[0])) && (!isNaN(c[1])) && (!isNaN(c[2]))) {valid = 'y'}
	return valid;
}

function cText(c) {
	var result = '';
	var d = 1;
	if (colType == 'rgbp') {d = 2.55}
	for (k = 0; k < 3; k++) {
		val = Math.round(c[k]/d);
		piece = val.toString(base);
		if (colType == 'hex' && piece.length < 2) {piece = '0' + piece;}
		if (colType == 'rgbp') {piece = piece + '%'};
		if (colType != 'hex' && k < 2) {piece = piece + ',';}
		result = result + piece;
	}
	if (colType == 'hex') {result = '#' + result.toUpperCase();}
		else {result = 'rgb(' + result + ')';}
	return result;
}


function colorParse(c,t) {
	var m = 1;
	c = c.toUpperCase();
	col = c.replace(/[\#rgb\(]*/,'');
	if (t == 'hex') {
		if (col.length == 3) {
			a = col.substr(0,1);
			b = col.substr(1,1);
			c = col.substr(2,1);
			col = a + a + b + b + c + c;
		}
		var num = new Array(col.substr(0,2),col.substr(2,2),col.substr(4,2));
		var base = 16;
	} else {
		var num = col.split(',');
		var base = 10;
	}
	if (t == 'rgbp') {m = 2.55}
	var ret = new Array(parseInt(num[0],base)*m,parseInt(num[1],base)*m,parseInt(num[2],base)*m);
	return(ret);
}


function mixPalette(start, end, decimal) {
	e = colorParse(end,colType)
	var ends = new Color(e[0],e[1],e[2]);

	s = colorParse(start,colType)
	var starts = new Color(s[0],s[1],s[2]);
	
	var r = (ends.r + ((starts.r - ends.r) * decimal));
	var g = (ends.g + ((starts.g - ends.g) * decimal));
	var b = (ends.b + ((starts.b - ends.b)  * decimal));
	return new Color(r,g,b);
}


function _error(type) {
	msg = "";
	if ( type == 'image_size' ) {
		msg += "No image sizes for " + image_size + " could be found. Have you set up your preferences yet?";
	}
	alert("ERROR: " + type + "\n" + msg);
}